/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.structures.rooms;

import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.structures.DungeonDoor;
import wayoftime.bloodmagic.structures.DungeonRoom;

public class DungeonRoomPlacement {
    public DungeonRoom room;
    public Random rand;
    public StructurePlaceSettings settings;
    public ServerLevel world;
    public BlockPos roomLocation;
    List<AreaDescriptor> descriptorList;
    List<DungeonDoor> containedDoorList;
    Pair<Direction, BlockPos> entrance;

    public DungeonRoomPlacement(DungeonRoom room, ServerLevel world, StructurePlaceSettings settings, BlockPos roomLocation, Pair<Direction, BlockPos> entrance) {
        this.rand = world.f_46441_;
        this.room = room;
        this.world = world;
        this.settings = settings;
        this.roomLocation = roomLocation;
        this.descriptorList = room.getAreaDescriptors(settings, roomLocation);
        this.containedDoorList = room.getPotentialConnectedRoomTypes(settings, roomLocation);
        this.entrance = entrance;
    }

    public void placeStructure() {
        this.room.placeStructureAtPosition(this.rand, this.settings, this.world, this.roomLocation);
    }

    public List<BlockPos> getDoorOffsetsForFacing(String doorType, Direction dir) {
        return this.room.getDoorOffsetsForFacing(this.settings, doorType, dir, this.roomLocation);
    }

    public List<AreaDescriptor> getAreaDescriptors() {
        return this.descriptorList;
    }

    public List<DungeonDoor> getPotentialConnectedRoomTypes() {
        return this.containedDoorList;
    }

    public Set<String> getAllRoomTypes() {
        return this.room.doorMap.keySet();
    }

    public Pair<Direction, BlockPos> getEntrance() {
        return this.entrance;
    }
}

